/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.respawnobelisks.config.ObeliskCoreConfig;
import com.redpxnda.respawnobelisks.config.TrustedPlayersConfig;
import com.redpxnda.respawnobelisks.data.listener.ObeliskCore;
import com.redpxnda.respawnobelisks.data.listener.ObeliskInteraction;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.block.RespawnObeliskBlock;
import com.redpxnda.respawnobelisks.registry.block.entity.theme.ObeliskThemeData;
import com.redpxnda.respawnobelisks.util.CoreUtils;
import com.redpxnda.respawnobelisks.util.ObeliskInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import org.slf4j.Logger;

public class RespawnObeliskBlockEntity
extends BlockEntity
implements GameEventListener {
    protected final List<Consumer<CompoundTag>> loadConsumers = new ArrayList<Consumer<CompoundTag>>();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Random RANDOM = new Random();
    private ObeliskCore.Instance coreItem;
    private BlockPositionSource source;
    private boolean hasLimboEntity;
    public ObeliskThemeData themeData = null;
    private long lastRespawn;
    private long lastCharge;
    public double clientCharge;
    public double clientMaxCharge;
    public boolean hasRandomCharge = true;
    private String obeliskName = "";
    private Component obeliskNameComponent = null;
    public final Map<UUID, ObeliskInventory> storedItems = new HashMap<UUID, ObeliskInventory>();
    public boolean hasStoredItems = false;
    public boolean hasTeleportingEntity = false;
    protected final List<String> themes = new ArrayList<String>();

    public RespawnObeliskBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModRegistries.RESPAWN_OBELISK_BE.get(), pos, blockState);
        this.coreItem = ObeliskCore.Instance.EMPTY;
        this.setupRandomCharge();
        this.source = new BlockPositionSource(this.m_58899_());
        this.lastRespawn = -100L;
        this.lastCharge = -100L;
        this.hasLimboEntity = false;
        this.themes.add("defaultCharge");
        this.themes.add("defaultDeplete");
        this.themes.add("defaultRunes");
    }

    public void setupRandomCharge() {
        if (this.hasRandomCharge && ((Boolean)this.m_58900_().m_61143_((Property)RespawnObeliskBlock.WILD)).booleanValue() && (double)RANDOM.nextInt(100) < ObeliskCoreConfig.wildCoreChance) {
            this.coreItem = ObeliskCoreConfig.getDefaultCore().getDefaultInstance();
            double charge = (float)(RANDOM.nextInt(ObeliskCoreConfig.wildMaxCharge - ObeliskCoreConfig.wildMinCharge) + ObeliskCoreConfig.wildMinCharge) / 100.0f;
            int maxCharge = RANDOM.nextInt(ObeliskCoreConfig.wildMaxMaxCharge - ObeliskCoreConfig.wildMinMaxCharge) + ObeliskCoreConfig.wildMinMaxCharge;
            this.setCharge(null, Math.round(charge * (double)maxCharge));
            this.setMaxCharge(null, maxCharge);
        }
        this.hasRandomCharge = false;
    }

    public boolean isPlayerTrusted(String username) {
        CompoundTag obeliskData;
        if (!CoreUtils.hasInteraction(this.coreItem, ObeliskInteraction.PROTECT)) {
            return true;
        }
        if (TrustedPlayersConfig.enablePlayerTrust && this.coreItem.stack().m_41784_().m_128441_("RespawnObeliskData") && (obeliskData = this.coreItem.stack().m_41783_().m_128469_("RespawnObeliskData")).m_128441_("TrustedPlayers")) {
            ListTag list = obeliskData.m_128437_("TrustedPlayers", 8);
            return list.contains((Object)StringTag.m_129297_((String)username));
        }
        return true;
    }

    public Component getObeliskNameComponent() {
        return this.obeliskNameComponent;
    }

    public String getObeliskName() {
        return this.obeliskName;
    }

    public boolean hasLimboEntity() {
        return this.hasLimboEntity;
    }

    public long getLastRespawn() {
        return this.lastRespawn;
    }

    public void setLastRespawn(long lastRespawn) {
        this.lastRespawn = lastRespawn;
    }

    public long getLastCharge() {
        return this.lastCharge;
    }

    public long getGameTime() {
        if (this.f_58857_ == null) {
            return -100L;
        }
        return this.f_58857_.m_46467_();
    }

    public void setLastCharge(long lastCharge) {
        this.lastCharge = lastCharge;
    }

    public double getClientCharge() {
        return this.clientCharge;
    }

    public double getClientMaxCharge() {
        return this.clientMaxCharge;
    }

    public double getCharge(@Nullable Player player) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return this.clientCharge;
        }
        if (this.coreItem.isEmpty() || this.coreItem.core().alwaysRequiresPlayer && player == null) {
            return 0.0;
        }
        return (Double)this.coreItem.core().chargeProvider.apply((Object)player, (Object)this.coreItem.stack(), (Object)this);
    }

    public double getMaxCharge(@Nullable Player player) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return this.clientMaxCharge;
        }
        if (this.coreItem.isEmpty() || this.coreItem.core().alwaysRequiresPlayer && player == null) {
            return 0.0;
        }
        return (Double)this.coreItem.core().maxChargeProvider.apply((Object)player, (Object)this.coreItem.stack(), (Object)this);
    }

    public void setMaxCharge(@Nullable Player player, double amnt) {
        if (this.coreItem.isEmpty() || this.coreItem.core().alwaysRequiresPlayer && player == null) {
            return;
        }
        this.coreItem.core().maxChargeSetter.call(amnt, player, this.coreItem.stack(), this);
    }

    public CompoundTag getItemNbt() {
        return this.coreItem.stack().m_41739_(new CompoundTag());
    }

    public CompoundTag getItemTag() {
        return this.coreItem.stack().m_41784_();
    }

    public void setItemFromNbt(CompoundTag tag, ObeliskCore core) {
        this.coreItem = new ObeliskCore.Instance(ItemStack.m_41712_((CompoundTag)tag), core);
    }

    public void setCharge(Player player, double charge) {
        if (this.coreItem.isEmpty() || this.coreItem.core().alwaysRequiresPlayer && player == null) {
            return;
        }
        this.coreItem.core().chargeSetter.call(charge, player, this.coreItem.stack(), this);
    }

    public void setCoreInstance(ItemStack stack, ObeliskCore core) {
        this.coreItem = new ObeliskCore.Instance(stack, core);
    }

    public void setCoreInstance(ObeliskCore.Instance instance) {
        this.coreItem = instance;
    }

    public ItemStack getItemStack() {
        return this.coreItem.stack();
    }

    public ObeliskCore.Instance getCoreInstance() {
        return this.coreItem;
    }

    public void chargeAndAnimate(Player player, double amnt) {
        boolean isNegative;
        boolean bl = isNegative = amnt < 0.0;
        if (this.m_58898_()) {
            if (isNegative) {
                this.setLastRespawn(this.f_58857_.m_46467_());
            } else {
                this.setLastCharge(this.f_58857_.m_46467_());
            }
        }
        this.increaseCharge(player, amnt);
    }

    public void decreaseCharge(Player player, double amnt) {
        this.setCharge(player, Mth.m_14008_((double)(this.getCharge(player) - amnt), (double)0.0, (double)this.getMaxCharge(player)));
        this.syncWithClient();
    }

    public void increaseCharge(Player player, double amnt) {
        this.setCharge(player, Mth.m_14008_((double)(this.getCharge(player) + amnt), (double)0.0, (double)this.getMaxCharge(player)));
        this.syncWithClient();
    }

    public void restoreSavedItems(Player player) {
        ObeliskInventory inv = this.storedItems.get(player.m_20148_());
        if (inv == null) {
            return;
        }
        if (!inv.isItemsEmpty()) {
            inv.items.forEach(i -> {
                if (!i.m_41619_()) {
                    player.m_150109_().m_150079_(i);
                }
            });
            inv.items.clear();
        }
        if (!inv.isArmorEmpty()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!slot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR) || inv.armor.size() <= slot.m_20749_()) continue;
                if (player.m_6844_(slot).m_41619_()) {
                    player.m_8061_(slot, inv.armor.get(slot.m_20749_()));
                    continue;
                }
                player.m_150109_().m_150079_(inv.armor.get(slot.m_20749_()));
            }
            inv.armor.clear();
        }
        if (!inv.isOffhandEmpty()) {
            if (player.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
                player.m_8061_(EquipmentSlot.OFFHAND, inv.offhand.get(0));
            } else {
                player.m_150109_().m_150079_(inv.offhand.get(0));
            }
            inv.offhand.clear();
        }
        if (inv.isXpEmpty()) {
            player.m_6756_(inv.xp);
            inv.xp = 0;
        }
        this.syncWithClient();
    }

    public void syncWithClient() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.updateHasSavedItems();
        RespawnObeliskBlockEntity.setChanged(this.f_58857_, this.m_58899_(), this.m_58900_());
    }

    public void updateHasSavedItems() {
        boolean isEmpty = true;
        for (ObeliskInventory inv : this.storedItems.values()) {
            if (inv.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        this.hasStoredItems = !isEmpty;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        boolean bl = this.hasRandomCharge = tag.m_128441_("RandomCharge") && tag.m_128471_("RandomCharge");
        if (!this.hasRandomCharge) {
            if (tag.m_128469_("Item").m_128441_("id")) {
                String str = tag.m_128469_("Item").m_128461_("id");
                if (str.equals("respawnobelisks:obelisk_core_nether") || str.equals("respawnobelisks:obelisk_core_end")) {
                    tag.m_128469_("Item").m_128359_("id", "respawnobelisks:obelisk_core");
                }
                LOGGER.warn("Respawn Obelisk at \"{}\" had an old core. Updating!", (Object)this.m_58899_());
                ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
                this.coreItem = stack == ItemStack.f_41583_ ? ObeliskCore.Instance.EMPTY : new ObeliskCore.Instance(stack, ObeliskCore.ANCIENT_CORE);
            } else {
                this.coreItem = (ObeliskCore.Instance)ObeliskCore.Instance.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("Item")).getOrThrow(false, s -> LOGGER.error("Failed to parse Obelisk's 'Item'. " + s));
            }
        } else {
            this.hasRandomCharge = false;
        }
        this.lastRespawn = tag.m_128454_("LastRespawn");
        this.lastCharge = tag.m_128454_("LastCharge");
        this.hasLimboEntity = tag.m_128471_("HasLimboEntity");
        this.hasStoredItems = tag.m_128471_("HasStoredItems");
        this.obeliskName = tag.m_128461_("Name");
        if (tag.m_128441_("ClientCharge")) {
            this.clientCharge = tag.m_128459_("ClientCharge");
        }
        if (tag.m_128441_("ClientMaxCharge")) {
            this.clientMaxCharge = tag.m_128459_("ClientMaxCharge");
        }
        if (tag.m_128425_("StoredItems", 10)) {
            CompoundTag stored = tag.m_128469_("StoredItems");
            for (String key : stored.m_128431_()) {
                this.storedItems.put(UUID.fromString(key), ObeliskInventory.readFromNbt(stored.m_128469_(key)));
            }
        }
        this.obeliskNameComponent = Component.Serializer.m_130701_((String)tag.m_128461_("Name"));
        this.hasTeleportingEntity = tag.m_128471_("HasTeleportingEntity");
        this.themes.clear();
        if (!tag.m_128425_("Themes", 9)) {
            this.themes.add("defaultCharge");
            this.themes.add("defaultDeplete");
            this.themes.add("defaultRunes");
        } else {
            tag.m_128437_("Themes", 8).forEach(t -> this.themes.add(t.m_7916_()));
        }
        this.loadConsumers.forEach(c -> c.accept(tag));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveData(tag, true, true);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.saveData(tag, false, true);
        return tag;
    }

    private void saveData(CompoundTag tag, boolean saveItems) {
        this.saveData(tag, saveItems, false);
    }

    private void saveData(CompoundTag tag, boolean saveItems, boolean sendCharge) {
        tag.m_128379_("RandomCharge", this.hasRandomCharge);
        tag.m_128365_("Item", (Tag)ObeliskCore.Instance.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.coreItem).getOrThrow(true, s -> LOGGER.error("Failed to save Obelisk's 'Item'. " + s)));
        tag.m_128356_("LastRespawn", this.lastRespawn);
        tag.m_128356_("LastCharge", this.lastCharge);
        tag.m_128379_("HasLimboEntity", this.hasLimboEntity);
        tag.m_128379_("HasStoredItems", this.hasStoredItems);
        tag.m_128359_("Name", this.obeliskName);
        if (saveItems) {
            CompoundTag allPlayers = new CompoundTag();
            for (UUID uuid : this.storedItems.keySet()) {
                allPlayers.m_128365_(uuid.toString(), (Tag)this.storedItems.get(uuid).saveToNbt());
            }
            tag.m_128365_("StoredItems", (Tag)allPlayers);
        }
        if (sendCharge) {
            tag.m_128347_("ClientCharge", this.getCharge(null));
            tag.m_128347_("ClientMaxCharge", this.getMaxCharge(null));
        }
        tag.m_128379_("HasTeleportingEntity", this.hasTeleportingEntity);
        ListTag list = new ListTag();
        this.themes.forEach(t -> list.add((Object)StringTag.m_129297_((String)t)));
        tag.m_128365_("Themes", (Tag)list);
    }

    protected static void setChanged(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        pLevel.m_7260_(pPos, pLevel.m_8055_(pPos), pState, 3);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, RespawnObeliskBlockEntity blockEntity) {
        if (level.m_46467_() % 100L == 0L && !level.f_46443_) {
            blockEntity.checkLimbo(true);
        }
    }

    public void updateObeliskName() {
        CompoundTag displayData;
        if (this.coreItem.stack().m_41784_().m_128441_("display") && (displayData = this.coreItem.stack().m_41783_().m_128469_("display")).m_128441_("Name")) {
            this.obeliskName = displayData.m_128461_("Name");
            return;
        }
        this.obeliskName = "";
    }

    public void checkLimbo(boolean shouldSync) {
        CompoundTag obeliskData;
        if (this.coreItem.stack().m_41784_().m_128441_("RespawnObeliskData") && (obeliskData = this.coreItem.stack().m_41783_().m_128469_("RespawnObeliskData")).m_128441_("SavedEntities")) {
            ListTag list = obeliskData.m_128437_("SavedEntities", 10);
            for (Tag tag : list) {
                Entity entity;
                CompoundTag compound;
                Level level = this.f_58857_;
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                if (!(tag instanceof CompoundTag) || !(compound = (CompoundTag)tag).m_128441_("uuid") || !compound.m_128441_("type") || !compound.m_128441_("data") || (entity = serverLevel.m_8791_(compound.m_128342_("uuid"))) != null && entity.m_6084_()) continue;
                this.hasLimboEntity = true;
                if (shouldSync) {
                    this.syncWithClient();
                }
                return;
            }
        }
        this.hasLimboEntity = false;
        if (shouldSync) {
            this.syncWithClient();
        }
    }

    public boolean m_214054_() {
        return true;
    }

    public PositionSource m_142460_() {
        return this.source;
    }

    public int m_142078_() {
        return 8;
    }

    public boolean m_214068_(ServerLevel serverLevel, GameEvent.Message message) {
        if (this.m_58901_() || this.coreItem.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (ObeliskInteraction interaction : ObeliskInteraction.EVENT_INTERACTIONS.getOrDefault(message.m_223740_(), Map.of()).values()) {
            if (!this.coreItem.core().interactions.contains(interaction.id)) continue;
            boolean bl = interaction.eventHandler.apply(this, message);
            result = !result ? bl : result;
        }
        return result;
    }
}

